// ################################################################################
//
//  RCWL_1601 Test vB0
//
//  Released:  24/12/2024
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.0.2

    This code was writtent to confirm the function of the three RCWL_1601 acoustic
    range sensors, used in the Omni-Bot project. Here, we trigger all three sensors
    from one output pin, and look for echoes on each of the three return paths.

    Enjoy!
*/

// Configuration
String Release = "RCWL_1601 Test ";
String Date = "24/06/2024";
String Rev = "vB0";

// Define constants
#define Echo0 16        // GPIO used for front sensor
#define Echo1  4        // GPIO used for right sensor
#define Echo2  2        // GPIO used for left sensor
#define echoLimit 5830  // echo limit for 1 metre distance
#define echoMax 1000    // Failed range response, 
#define RangeLL 40      // Range finder lower limit
#define RangeMax 1000   // Failed range reading, set to 1000 mm
#define RangeUL 800     // Range finder upper limit
#define Trig  14        // GPIO used for trigger pulse

// Define global variables
bool echoIn0;                 // value read from GPIO pin
bool echoIn1;                 // value read from GPIO pin
bool echoIn2;                 // value read from GPIO pin
bool echoLast0 = LOW;         // previous echo value
bool echoLast1 = LOW;         // previous echo value
bool echoLast2 = LOW;         // previous echo value
int32_t echoLimit0;           // time limit for max echo response
int32_t echoLimit1;           // time limit for max echo response
int32_t echoLimit2;           // time limit for max echo response
bool echoRead = false;        // if == true then read echo pins
int16_t echoStep0 = 0;        // state machine pointer for echo 0
int16_t echoStep1 = 0;        // state machine pointer for echo 1
int16_t echoStep2 = 0;        // state machine pointer for echo 2
int32_t echoT0;               // GPIO echo time
int32_t echoT1;               // GPIO echo time
int32_t echoT2;               // GPIO echo time
int32_t echoTime0 = 0;        // sensor echo time in miucroseconds
int32_t echoTime1 = 0;        // sensor echo time in miucroseconds
int32_t echoTime2 = 0;        // sensor echo time in miucroseconds
int32_t Range0 = RangeUL;     // set default range to the upper limit
int32_t Range1 = RangeUL;     // set default range to the upper limit
int32_t Range2 = RangeUL;     // set default range to the upper limit
int32_t RangeAvg0 = RangeUL;  // set the default average range to the upper limit
int32_t RangeAvg1 = RangeUL;  // set the default average range to the upper limit
int32_t RangeAvg2 = RangeUL;  // set the default average range to the upper limit
int32_t RangeLast0 = RangeUL; // previous range value
int32_t RangeLast1 = RangeUL; // previous range value
int32_t RangeLast2 = RangeUL; // previous range value
int32_t RangeTime0;           // set default range time
int32_t RangeTime1;           // set default range time
int32_t RangeTime2;           // set default range time
int32_t RangeTimer;           // loop timer, used to trigger range measurements
bool ReadEnd0;                // end of read cycle flag
bool ReadEnd1;                // end of read cycle flag
bool ReadEnd2;                // end of read cycle flag

// --------------------------------------------------------------------------------

void setup() {
  pinMode(Trig, OUTPUT); digitalWrite(Trig,LOW);
  pinMode(Echo0, INPUT_PULLUP);
  pinMode(Echo1, INPUT_PULLUP);
  pinMode(Echo2, INPUT_PULLUP);

  Serial.begin(115200);
  delay(100);
  Serial.println(Release + Rev);
  Serial.println(Date);
  
  Serial.println("\nOff we go...\n");
  RangeTimer = millis();  // reaset the timer
}

// --------------------------------------------------------------------------------

void loop(void) {
  // Here we trigger the sensor and read their responses
  if ((millis() - RangeTimer) >= 20) {
    // The time has triggered, so initiate another set of readings
    RangeTimer = millis();  // reaset the timer

    // We calculate the distance in mm directly from the echo time.
    // For echoed sound to travel 800mm, it takes 4.664 milliseconds
    // First get the Range measurements from the previous run
    RangeLast0 = Range0;
    if (echoStep0 == 2) {
      Range0 = (100 * echoTime0)/583;
      RangeTime0 = echoTime0;                     // save value for Monitor+ display
      if (Range0 > RangeUL) {Range0 = RangeMax;}   // limit Range to 800mm, then set to max 1000mm
      if (RangeAvg0 == 0) {RangeAvg0 = Range0;}   // don't average 1st reading
      else {RangeAvg0 = RangeLast0 + ((Range0 - RangeLast0)/2);}
    } else {Range0 = RangeMax; RangeAvg0 = RangeMax; RangeTime0 = 10000;}  // no valid pulse
    RangeLast1 = Range1;
    if (echoStep1 == 2) {
      Range1 = (100 * echoTime1)/583;
      RangeTime1 = echoTime1;                     // save value for Monitor+ display
      if (Range1 > RangeUL) {Range1 = RangeMax;}   // limit Range to 800mm
      if (RangeAvg1 == 0) {RangeAvg1 = Range1;}    // don't average 1st reading
      else {RangeAvg1 = RangeLast1 + ((Range1 - RangeLast1)/2);}
    } else {Range1 = RangeMax; RangeAvg1 = RangeMax; RangeTime1 = 10000;}  // no valid pulse
    RangeLast2 = Range2;
    if (echoStep2 == 2) {
      Range2 = (100 * echoTime2)/583;
      RangeTime2 = echoTime2;                     // save value for Monitor+ display
      if (Range2 > RangeUL) {Range2 = RangeMax;}   // limit Range to 800mm
      if (RangeAvg2 == 0) {RangeAvg2 = Range2;}    // don't average 1st reading
      else {RangeAvg2 = RangeLast2 + ((Range2 - RangeLast2)/2);}
    } else {Range2 = RangeMax; RangeAvg2 = RangeMax; RangeTime2 = 10000;}  // no valid pulse
    // Print results
    Serial.println(String(Range0) + ",\t" + String(Range1) + ",\t" + String(Range2) + ",\t0");
    // Now prepare for the next measurement
    echoLast0 = digitalRead(Echo0);
    echoLast1 = digitalRead(Echo1);
    echoLast2 = digitalRead(Echo2);
    // Off we go... trigger the RCWL-1601 with a short pulse
    digitalWrite(Trig,HIGH);
    delayMicroseconds(10);
    digitalWrite(Trig,LOW);
    // Set flags for the next reads
    echoT0 = micros(); 
    echoLimit0 = echoT0 + echoLimit;            // set time limit, adjusted later by an echo start
    echoLimit1 = echoLimit0;                    // set time limit, adjusted later by an echo start
    echoLimit2 = echoLimit0;                    // set time limit, adjusted later by an echo start
    echoStep0 = 0; ReadEnd0 = false;            // reset the Step state machine
    echoStep1 = 0; ReadEnd1 = false;            // reset the Step state machine
    echoStep2 = 0; ReadEnd2 = false;            // reset the Step state machine
    echoRead = true;                            // start the echo reading process
  }

  //###############################################################################
  //
  //  Range finder - RCWL-1601
  //
  //###############################################################################
  // This code runs every loop cycle once echoRead == true to determine an echo pulse
  // width, for a Range value. Whilst the accuracy of the range time measurement is
  // potentially reduced by this method, it is preferred over using the pulse()
  //  method, as it unlocks the micro to run multiple sensors at once.
  // processing time .
  // If...
  // echoStep == 0 we have not yet seen a +ve pulse
  // echoStep == 1 we have seen the rising edge of the pulse, and waiting for its fall
  // echoStep == 2 we have seen the falling edge of the pulse and recorded it
  // echoStep  > 2 we have seen too many edges on the pulse 
  if (echoRead) {
    // Start by reading the echo pins
    echoIn0 = digitalRead(Echo0); echoT0 = micros();
    echoIn1 = digitalRead(Echo1); echoT1 = micros();
    echoIn2 = digitalRead(Echo2); echoT2 = micros();
    // now look for changes on each pin
    if (!ReadEnd0) {
      if (echoIn0 != echoLast0) {
        // a pin transition has occured
        if (echoIn0) {
          // this is a LOW to HIGH transition, in response to the trigger pulse
          echoStep0++; if (echoStep0 == 1) {echoTime0 = echoT0; echoLimit0 = echoT0 + echoLimit;}
        } else {
          // this is a HIGH to LOW transition, on receipt of an echo
          echoStep0++; if (echoStep0 == 2) {echoTime0 = echoT0 - echoTime0; ReadEnd0 = true;}
        } echoLast0 = echoIn0;
      } else {
        // No transition of echo pin, so check for timeout
        if (echoT0 >= echoLimit0) {echoTime0 = echoLimit; ReadEnd0 = true;}
      }
    }
    if (!ReadEnd1) {
      if (echoIn1 != echoLast1) {// a transition has occured
        if (echoIn1) {
          // this is a LOW to HIGH transition, in response to the trigger pulse
          echoStep1++; if (echoStep1 == 1) {echoTime1 = echoT1; echoLimit1 = echoT1 + echoLimit;}
        } else {
          // this is a HIGH to LOW transition, on receipt of an echo
          echoStep1++; if (echoStep1 == 2) {echoTime1 = echoT1 - echoTime1; ReadEnd1 = true;}
        } echoLast1 = echoIn1;
      } else {
        // No transition of echo pin, so check for timeout
        if (echoT1 >= echoLimit1) {echoTime1 = echoLimit; ReadEnd1 = true;}
      }
    }
    if (!ReadEnd2) {
      if (echoIn2 != echoLast2) {// a transition has occured
        if (echoIn2) {
          // this is a LOW to HIGH transition, in response to the trigger pulse
          echoStep2++; if (echoStep2 == 1) {echoTime2 = echoT2; echoLimit2 = echoT2 + echoLimit;}
        } else {
          // this is a HIGH to LOW transition, on receipt of an echo
          echoStep2++; if (echoStep2 == 2) {echoTime2 = echoT2 - echoTime2; ReadEnd2 = true;}
        } echoLast2 = echoIn2;
      } else {
        // No transition of echo pin, so check for timeout
        if (echoT2 >= echoLimit2) {echoTime2 = echoLimit; ReadEnd2 = true;}
      }
    }
    if (ReadEnd0 && ReadEnd1 && ReadEnd2) {echoRead = false;}
  }
}

// --------------------------------------------------------------------------------

